IF EXISTS ( SELECT * 
            FROM   sysobjects 
            WHERE  id = object_id(N'dbo.CF_BancoBBVA_Proveedores_OP_Reg_90_TX') 
                   and type = 'FN')
BEGIN
    DROP FUNCTION dbo.CF_BancoBBVA_Proveedores_OP_Reg_90_TX
END
GO

CREATE FUNCTION [dbo].[CF_BancoBBVA_Proveedores_OP_Reg_90_TX](@pId_Trans INT, @pCuitEmpresa VARCHAR(13), @pNroSecuencia INT) 
RETURNS CHAR(850)
AS
BEGIN

/*================================================================================================================================*/

/*Variables del Archivo.*/
DECLARE @Retorno						CHAR(850)

/*--------------------------------------------------------------------------------------------------------------------------------*/
DECLARE @aIDENT_REGISTRO		CHAR(4)	--NRO: 01. NOMBRE: IDENT-REGISTRO.		TIPO: N. TAM: 4. POS. INI: 1. POS_FIN: 4. OBSERVACION:OBL fijo 0306
DECLARE @aTIPO_REG				CHAR(3)	--NRO: 02. NOMBRE: TIPO-REG.			TIPO: N. TAM: 3. POS. INI: 5. POS_FIN: 7. OBSERVACION:OBL fijo 090
DECLARE @aTIPO_DOC_EMPRE		CHAR(4)	--NRO: 03. NOMBRE: TIPO-DOC-EMPRE.		TIPO: X. TAM: 4. POS. INI: 8. POS_FIN: 11. OBSERVACION:OBL 'CUIT' tipo documento
DECLARE @aNRO_CUIT_EMPRE		CHAR(13)--NRO: 04. NOMBRE: NRO-CUIT-EMPRE.		TIPO: N. TAM: 13. POS. INI: 12. POS_FIN: 24. OBSERVACION:OBL numero de cuit
DECLARE @aSECUENCIA				CHAR(6)	--NRO: 05. NOMBRE: SECUENCIA.			TIPO: N. TAM: 6. POS. INI: 25. POS_FIN: 30. OBSERVACION:OBL Numero correlativo del registro sin contar la cabecera.
DECLARE @aPRO_NRO_ORD			CHAR(15)--NRO: 06. NOMBRE: PRO-NRO-ORD.			TIPO: X. TAM: 15. POS. INI: 31. POS_FIN: 45. OBSERVACION:OBL  Nombre del archivo
DECLARE @aPRO_NRO_BENEF			CHAR(15)--NRO: 07. NOMBRE: PRO-NRO-BENEF.		TIPO: N. TAM: 15. POS. INI: 46. POS_FIN: 60. OBSERVACION:OBL  Numero de beneficiario
DECLARE @aPRO_EST_BENEF			CHAR(1)	--NRO: 08. NOMBRE: PRO-EST-BENEF.		TIPO: X. TAM: 1. POS. INI: 61. POS_FIN: 61. OBSERVACION: OBL Situacion del beneficiario.  Fijo 1.
DECLARE @aPRO_DOCTO_TIP			CHAR(3)	--NRO: 09. NOMBRE: PRO-DOCTO-TIP.		TIPO: X. TAM: 3. POS. INI: 62. POS_FIN: 64. OBSERVACION:OBL Tipo documento proveedor. CUI : CUIT. CUL : CUIL. DNI : Documento Nacional de Identidad. PAS : Pasaporte de extranjero. CIE : Cdula de identidad de polica. DNE : Documento Nacional Extranjero. CDI : Codigo de identificacion que el organismo otorga a aquellos ciudadanos que no poseen CUIT ni CUIL por no existir causales de ndole fiscal o previsional que los obligue. CIE : Cdula de identidad de polica federal para extranjeros. DUM:Documento ?nico sexo masculino. DUF: Documento ?nico, sexo femenino. Tanto el Tipo DUM como el DUF solo aplica a personas  con numero de documento menor a diez millones. Relacionado con tipo-documento del Registro 20.
DECLARE @aPRO_DOCTO_NRO			CHAR(11)--NRO: 10. NOMBRE: PRO-DOCTO-NRO.		TIPO: N. TAM: 11. POS. INI: 65. POS_FIN: 75. OBSERVACION: OBL Nro. documento proveedor
DECLARE @aPRO_DENOMINA			CHAR(40)--NRO: 11. NOMBRE: PRO-DENOMINA.		TIPO: X. TAM: 40. POS. INI: 76. POS_FIN: 115. OBSERVACION: OBL Denominacion del proveedor
DECLARE @aPRO_CATEGO			CHAR(2)	--NRO: 12. NOMBRE: PRO-CATEGO .			TIPO: X. TAM: 2. POS. INI: 116. POS_FIN: 117. OBSERVACION: OPC Relleno a blancos
DECLARE @aPRO_PERMIT_FINAN		CHAR(1)	--NRO: 13. NOMBRE: PRO-PERMIT-FINAN.	TIPO: X. TAM: 1. POS. INI: 118. POS_FIN: 118. OBSERVACION:OPC la empresa habilita al proveedor a realizar financiacion manual o voluntaria del pago.  S: habilita. Blanco o N: no habilita.
DECLARE @aPRO_CUS_TIP			CHAR(2)	--NRO: 14. NOMBRE: PRO-CUS-TIP.			TIPO: N. TAM: 2. POS. INI: 119. POS_FIN: 120. OBSERVACION: OPC Relleno con ceros (se utilizaba para bonos).
DECLARE @aPRO_CUS_SUC			CHAR(3)	--NRO: 15. NOMBRE: PRO-CUS-SUC.			TIPO: N. TAM: 3. POS. INI: 121. POS_FIN: 123. OBSERVACION: OPC Relleno con ceros (se utilizaba para bonos).
DECLARE @aPRO_CUS_NRO			CHAR(10)--NRO: 16. NOMBRE: PRO-CUS-NRO.			TIPO: N. TAM: 10. POS. INI: 124. POS_FIN: 133. OBSERVACION:OPC  Relleno con ceros (se utilizaba para bonos).
DECLARE @aPRO_CBU_NRO			CHAR(22)--NRO: 17. NOMBRE: PRO-CBU-NRO.			TIPO: N. TAM: 22. POS. INI: 134. POS_FIN: 155. OBSERVACION: OPC Numero CBU.  Obligatorio para clientes con forma de pago acreditacion en cuenta.
DECLARE @aPRO_INGBRTS			CHAR(11)--NRO: 18. NOMBRE: PRO-INGBRTS.			TIPO: X. TAM: 11. POS. INI: 156. POS_FIN: 166. OBSERVACION: OPC Numero Ingresos Brutos
DECLARE @aPRO_CALLE				CHAR(24)--NRO: 19. NOMBRE: PRO-CALLE .			TIPO: X. TAM: 24. POS. INI: 167. POS_FIN: 190. OBSERVACION:  OBL Calle
DECLARE @aPRO_NUMERO			CHAR(5)	--NRO: 20. NOMBRE: PRO-NUMERO.			TIPO: X. TAM: 5. POS. INI: 191. POS_FIN: 195. OBSERVACION:  OPC Puerta
DECLARE @aPRO_DEPTO				CHAR(3)	--NRO: 21. NOMBRE: PRO-DEPTO .			TIPO: X. TAM: 3. POS. INI: 196. POS_FIN: 198. OBSERVACION:  OPC Departamento
DECLARE @aPRO_PISO				CHAR(2)	--NRO: 22. NOMBRE: PRO-PISO  .			TIPO: X. TAM: 2. POS. INI: 199. POS_FIN: 200. OBSERVACION:  OPC Piso
DECLARE @aPRO_LOCALID			CHAR(28)--NRO: 23. NOMBRE: PRO-LOCALID.			TIPO: X. TAM: 28. POS. INI: 201. POS_FIN: 228. OBSERVACION:  OPC Localidad
DECLARE @aPRO_CPOSTAL			CHAR(5)	--NRO: 24. NOMBRE: PRO-CPOSTAL.			TIPO: X. TAM: 5. POS. INI: 229. POS_FIN: 233. OBSERVACION:  OPC Codigo Postal
DECLARE @aPRO_CODPROV			CHAR(2)	--NRO: 25. NOMBRE: PRO-CODPROV.			TIPO: X. TAM: 2. POS. INI: 234. POS_FIN: 235. OBSERVACION:  OBL Codigo de provincia, segun tabla adjunta.
DECLARE @aPRO_CODPAIS			CHAR(3)	--NRO: 26. NOMBRE: PRO-CODPAIS.			TIPO: X. TAM: 3. POS. INI: 236. POS_FIN: 238. OBSERVACION:  OPC Codigo de pais, Fijo 080
DECLARE @aPRO_EMAIL				CHAR(40)--NRO: 27. NOMBRE: PRO-EMAIL .			TIPO: X. TAM: 40. POS. INI: 239. POS_FIN: 278. OBSERVACION: OPC  Direccion correo electronico
DECLARE @aPRO_CALLE_ENTREGA     CHAR(24)--NRO: 28. NOMBRE: PRO-CALLE-ENTREGA.	TIPO: X. TAM: 24. POS. INI: 279. POS_FIN: 302. OBSERVACION: OPC  Relleno a blancos
DECLARE @aPRO_NUMERO_ENTREGA    CHAR(5)	--NRO: 29. NOMBRE: PRO-NUMERO-ENTREGA.	TIPO: X. TAM: 5. POS. INI: 303. POS_FIN: 307. OBSERVACION:OPC Relleno a blancos
DECLARE @aPRO_DEPTO_ENTREGA     CHAR(3)	--NRO: 30. NOMBRE: PRO-DEPTO-ENTREGA.	TIPO: X. TAM: 3. POS. INI: 308. POS_FIN: 310. OBSERVACION: OPC  Relleno a blancos
DECLARE @aPRO_PISO_ENTREGA      CHAR(2)	--NRO: 31. NOMBRE: PRO-PISO-ENTREGA.	TIPO: X. TAM: 2. POS. INI: 311. POS_FIN: 312. OBSERVACION:OPC   Relleno a blancos
DECLARE @aPRO_LOCALID_ENTREGA   CHAR(28)--NRO: 32. NOMBRE: PRO-LOCALID-ENTREGA.	TIPO: X. TAM: 28. POS. INI: 313. POS_FIN: 340. OBSERVACION:OPC  Relleno a blancos
DECLARE @aPRO_CPOSTAL_ENTREGA   CHAR(5)	--NRO: 33. NOMBRE: PRO-CPOSTAL-ENTREGA.	TIPO: X. TAM: 5. POS. INI: 341. POS_FIN: 345. OBSERVACION: OPC Relleno a blancos
DECLARE @aPRO_CODPROV_ENTREGA   CHAR(2)	--NRO: 34. NOMBRE: PRO-CODPROV-ENTREGA.	TIPO: X. TAM: 2. POS. INI: 346. POS_FIN: 347. OBSERVACION: OPC  Relleno a blancos
DECLARE @aPRO_CODPAIS_ENTREGA   CHAR(3)	--NRO: 35. NOMBRE: PRO-CODPAIS-ENTREGA.	TIPO: X. TAM: 3. POS. INI: 348. POS_FIN: 350. OBSERVACION: OPC Relleno a blancos
DECLARE @aPRO_TELEF_TIP			CHAR(2)	--NRO: 36. NOMBRE: PRO-TELEF-TIP.		TIPO: X. TAM: 2. POS. INI: 351. POS_FIN: 352. OBSERVACION:OPC Tipo de telefonia. Valores posibles: 01 : Telfono. 02 : Tlex. 03 : Tel Celular. 04 : Fax. 05 : Radio llamada. 06 : Radio. 07 : Comunitario. 00 : Sin informacion
DECLARE @aPRO_TELEF_PRE			CHAR(4)	--NRO: 37. NOMBRE: PRO-TELEF-PRE.		TIPO: X. TAM: 4. POS. INI: 353. POS_FIN: 356. OBSERVACION: OPC  Prefijo telefonico
DECLARE @aPRO_TELEF_CAR			CHAR(4)	--NRO: 38. NOMBRE: PRO-TELEF-CAR.		TIPO: X. TAM: 4. POS. INI: 357. POS_FIN: 360. OBSERVACION:OPC  Caracterstica telefonica
DECLARE @aPRO_TELEF_NRO			CHAR(5)	--NRO: 39. NOMBRE: PRO-TELEF-NRO.		TIPO: X. TAM: 5. POS. INI: 361. POS_FIN: 365. OBSERVACION:OPC  Numero telefonico
DECLARE @aPRO_TELEF_INT			CHAR(18)--NRO: 40. NOMBRE: PRO-TELEF-INT.		TIPO: X. TAM: 18. POS. INI: 366. POS_FIN: 383. OBSERVACION: OPC Interno
DECLARE @aPRO_TELEF_ALTER_TIP   CHAR(2)	--NRO: 41. NOMBRE: PRO-TELEF-ALTER-TIP. TIPO: X. TAM: 2. POS. INI: 384. POS_FIN: 385. OBSERVACION:OPC Tipo de telefonia (Alternativa). Valores posibles: 01 : Telfono. 02 : Tlex. 03 : Tel Celular. 04 : Fax. 05 : Radio llamada. 06 : Radio. 07 : Comunitario. 00 : Sin informacion
DECLARE @aPRO_TELEF_ALTER_PRE   CHAR(4)	--NRO: 42. NOMBRE: PRO-TELEF-ALTER-PRE. TIPO: X. TAM: 4. POS. INI: 386. POS_FIN: 389. OBSERVACION:OPC Prefijo telefonico (alternativo)
DECLARE @aPRO_TELEF_ALTER_CAR   CHAR(4)	--NRO: 43. NOMBRE: PRO-TELEF-ALTER-CAR. TIPO: X. TAM: 4. POS. INI: 390. POS_FIN: 393. OBSERVACION: OPC Caracterstica telefonica(alternativa)
DECLARE @aPRO_TELEF_ALTER_NRO   CHAR(5)	--NRO: 44. NOMBRE: PRO-TELEF-ALTER-NRO. TIPO: X. TAM: 5. POS. INI: 394. POS_FIN: 398. OBSERVACION:OPC Numero telefonico (alternativo)
DECLARE @aPRO_TELEF_ALTER_INT   CHAR(18)--NRO: 45. NOMBRE: PRO-TELEF-ALTER-INT. TIPO: X. TAM: 18. POS. INI: 399. POS_FIN: 416. OBSERVACION:OPC Interno
DECLARE @aPRO_AUTORIZA_NOM1		CHAR(25)--NRO: 46. NOMBRE: PRO-AUTORIZA-NOM1.	TIPO: X. TAM: 25. POS. INI: 417. POS_FIN: 441. OBSERVACION:OPC Nombre persona autorizada   [ 1 ]
DECLARE @aPRO_AUTORIZA_TIP1		CHAR(3)	--NRO: 47. NOMBRE: PRO-AUTORIZA-TIP1.	TIPO: X. TAM: 3. POS. INI: 442. POS_FIN: 444. OBSERVACION:OPC Tipo documento persona autorizada. CUI : CUIT. DNI : Documento Nacional de Identidad. LC : Libreta Cvica. LE : Libreta de Enrolamieto. PAS : Pasaporte de extranjero. CIE : Cdula de identidad de polica federal para extranjeros.
DECLARE @aPRO_AUTORIZA_DOC1		CHAR(8)	--NRO: 48. NOMBRE: PRO-AUTORIZA-DOC1.	TIPO: N. TAM: 8. POS. INI: 445. POS_FIN: 452. OBSERVACION: OPC Nro.documento persona autorizada  
DECLARE @aPRO_AUTORIZA_NOM2		CHAR(25)--NRO: 49. NOMBRE: PRO-AUTORIZA-NOM2.	TIPO: X. TAM: 25. POS. INI: 453. POS_FIN: 477. OBSERVACION:OPC Nombre persona autorizada   [ 2 ]
DECLARE @aPRO_AUTORIZA_TIP2		CHAR(3)	--NRO: 50. NOMBRE: PRO-AUTORIZA-TIP2.	TIPO: X. TAM: 3. POS. INI: 478. POS_FIN: 480. OBSERVACION:OPC Tipo documento persona autorizada. CUI : CUIT. DNI : Documento Nacional de Identidad. LC : Libreta Cvica. LE : Libreta de Enrolamieto. PAS : Pasaporte de extranjero. CIE : Cdula de identidad de polica federal para extranjeros.
DECLARE @aPRO_AUTORIZA_DOC2		CHAR(8)	--NRO: 51. NOMBRE: PRO-AUTORIZA-DOC2.	TIPO: N. TAM: 8. POS. INI: 481. POS_FIN: 488. OBSERVACION:OPC Nro.documento persona autorizada  
DECLARE @aPRO_AUTORIZA_NOM3		CHAR(25)--NRO: 52. NOMBRE: PRO-AUTORIZA-NOM3.	TIPO: X. TAM: 25. POS. INI: 489. POS_FIN: 513. OBSERVACION:OPC Nombre persona autorizada   [ 3 ]
DECLARE @aPRO_AUTORIZA_TIP3		CHAR(3)	--NRO: 53. NOMBRE: PRO-AUTORIZA-TIP3.	TIPO: X. TAM: 3. POS. INI: 514. POS_FIN: 516. OBSERVACION:OPC Tipo documento persona autorizada. CUI : CUIT. DNI : Documento Nacional de Identidad. LC : Libreta Cvica. LE : Libreta de Enrolamieto. PAS : Pasaporte de extranjero. CIE : Cdula de identidad de polica federal para extranjeros.
DECLARE @aPRO_AUTORIZA_DOC3		CHAR(8)	--NRO: 54. NOMBRE: PRO-AUTORIZA-DOC3.	TIPO: N. TAM: 8. POS. INI: 517. POS_FIN: 524. OBSERVACION:OPC Nro.documento persona autorizada  
DECLARE @aPRO_DATOS				CHAR(100)--NRO: 55. NOMBRE: PRO-DATOS.			TIPO: X. TAM: 100. POS. INI: 525. POS_FIN: 624. OBSERVACION:OPC 
DECLARE @aPRO_MINUTA			CHAR(8)	--NRO: 56. NOMBRE: PRO-MINUTA.			TIPO: N. TAM: 8. POS. INI: 625. POS_FIN: 632. OBSERVACION:OBL numero de orden de pago. Debe ser mayor a ceros.  Si el pago es con impresion de minutas no puede repetirse.
DECLARE @aFILLER				CHAR(217)--NRO: 57. NOMBRE: FILLER.				TIPO: X. TAM: 217. POS. INI: 633. POS_FIN: 850. OBSERVACION:Relleno a blancos

/*================================================================================================================================*/

/*Variables de Calculo intermedio*/
DECLARE @Id_Proveedor				INT
DECLARE @Cuit_Proveedor				VARCHAR(11)
DECLARE @Razon_Social_Proveedor		VARCHAR(100)
DECLARE @CBU_Proveedor				VARCHAR(22)
DECLARE @Ingresos_Brutos_Proveedor	VARCHAR(20)
DECLARE @Direccion_Proveedor		VARCHAR(100)
DECLARE @Cp_Proveedor				VARCHAR(10)
DECLARE @Id_Localidad_Proveedor		INT
DECLARE @Id_Provincia_Proveedor		CHAR(3)
DECLARE @email_Proveedor			VARCHAR(8000)
/*FIN Variables de Calculo intermedio*/


/*Asignacion de variables*/
SELECT
@Id_Proveedor	= ISNULL(Id_Proveedor, 0)
FROM Cbtes
WHERE
Id_Trans = @pId_Trans

SELECT
@Cuit_Proveedor				= SUBSTRING(LTRIM(RTRIM(ISNULL(Cuit, ''))), 1, 11),
@Razon_Social_Proveedor		= ISNULL(Razon_Social, ''),
@CBU_Proveedor				= ISNULL(CBU, ''),
@Ingresos_Brutos_Proveedor	= ISNULL(LTRIM(RTRIM(REPLACE(ingresos_brutos, 'CM', ''))), ''),
@Direccion_Proveedor		= ISNULL(Direccion, ''),
@Id_Localidad_Proveedor		= ISNULL(Id_Localidad, 0),
@Cp_Proveedor				= ISNULL(Cp, ''),
@Id_Provincia_Proveedor		= ISNULL(Id_Provincia, ''),
@email_Proveedor			= SUBSTRING(CONVERT(VARCHAR(8000), ISNULL(email, '')), 1, 40)
FROM Proveedores
WHERE
Id_Proveedor = @Id_Proveedor
/*FIN Asignacion de variables*/

/*================================================================================================================================*/

SET @aIDENT_REGISTRO		= '0306'
SET @aTIPO_REG				= '090'
SET @aTIPO_DOC_EMPRE		= 'CUIT'
SET @aNRO_CUIT_EMPRE		= (SELECT RIGHT('0000000000000' + CAST(@pCuitEmpresa AS VARCHAR), 13))
SET @aSECUENCIA				= (SELECT RIGHT('000000' + CAST(@pNroSecuencia AS VARCHAR), 6))
SET @aPRO_NRO_ORD			= 'PUBL_MP        '
SET @aPRO_NRO_BENEF			= (SELECT RIGHT('000000000000000' + CAST(@Id_Proveedor AS VARCHAR), 15))
SET @aPRO_EST_BENEF			= '1' --??
SET @aPRO_DOCTO_TIP			= 'CUI' /*CUIT*/
SET @aPRO_DOCTO_NRO			= (SELECT RIGHT('00000000000' + CAST(@Cuit_Proveedor AS VARCHAR), 11))
SET @aPRO_DENOMINA			= @Razon_Social_Proveedor
SET @aPRO_CATEGO			= '  '
SET @aPRO_PERMIT_FINAN		= ' '
SET @aPRO_CUS_TIP			= '00'
SET @aPRO_CUS_SUC			= '000'
SET @aPRO_CUS_NRO			= '0000000000'
SET @aPRO_CBU_NRO			= @CBU_Proveedor
SET @aPRO_INGBRTS			= (SELECT RIGHT('00000000000' + CAST(CONVERT(BIGINT, REPLACE (@Ingresos_Brutos_Proveedor, '-', '')) AS VARCHAR), 11))
SET @aPRO_CALLE				= @Direccion_Proveedor
SET @aPRO_NUMERO			= '00000'	/*No tenemos el numero separado*/
SET @aPRO_DEPTO				= '   '		/*No tenemos el depto separado*/
SET @aPRO_PISO				= '00'		/*No tenemos el Nro Piso sepadao*/
SET @aPRO_LOCALID			= ISNULL((SELECT ISNULL(Descripcion, '') FROM Tab_Localidades WHERE Id_Localidad = @Id_Localidad_Proveedor), '')
SET @aPRO_CPOSTAL			= @Cp_Proveedor
SET @aPRO_CODPROV			= (dbo.CFU_BancoBBVA_Proveedores_OP_Provincias(@Id_Provincia_Proveedor))
SET @aPRO_CODPAIS			= '080'
SET @aPRO_EMAIL				= @email_Proveedor
SET @aPRO_CALLE_ENTREGA		= '                        '
SET @aPRO_NUMERO_ENTREGA	= '     '
SET @aPRO_DEPTO_ENTREGA		= '   '
SET @aPRO_PISO_ENTREGA		= '  '
SET @aPRO_LOCALID_ENTREGA	= '                            '
SET @aPRO_CPOSTAL_ENTREGA	= '     '
SET @aPRO_CODPROV_ENTREGA	= '  '
SET @aPRO_CODPAIS_ENTREGA	= '   '
SET @aPRO_TELEF_TIP			= '00' /*Sin informacion*/
SET @aPRO_TELEF_PRE			= '    '
SET @aPRO_TELEF_CAR			= '    '
SET @aPRO_TELEF_NRO			= '     '
SET @aPRO_TELEF_INT			= '                  '
SET @aPRO_TELEF_ALTER_TIP	= '00' /*Sin informacion*/
SET @aPRO_TELEF_ALTER_PRE	= '    '
SET @aPRO_TELEF_ALTER_CAR	= '    '
SET @aPRO_TELEF_ALTER_NRO	= '     '
SET @aPRO_TELEF_ALTER_INT	= '                  '
SET @aPRO_AUTORIZA_NOM1		= '                         '
SET @aPRO_AUTORIZA_TIP1		= '   '
SET @aPRO_AUTORIZA_DOC1		= '00000000'
SET @aPRO_AUTORIZA_NOM2		= '                         '
SET @aPRO_AUTORIZA_TIP2		= '   '
SET @aPRO_AUTORIZA_DOC2		= '00000000'
SET @aPRO_AUTORIZA_NOM3		= '                         '
SET @aPRO_AUTORIZA_TIP3		= '   '
SET @aPRO_AUTORIZA_DOC3		= '00000000'
SET @aPRO_DATOS				= '                                                                                                    '
SET @aPRO_MINUTA			= (SELECT RIGHT('00000000' + CAST(@pId_Trans AS VARCHAR), 8))
SET @aFILLER				= '                                                                                                                                                                                                                          '

/*================================================================================================================================*/

SET @Retorno =	@aIDENT_REGISTRO + 
				@aTIPO_REG + 
				@aTIPO_DOC_EMPRE + 
				@aNRO_CUIT_EMPRE + 
				@aSECUENCIA + 
				@aPRO_NRO_ORD + 
				@aPRO_NRO_BENEF   + 
				@aPRO_EST_BENEF   + 
				@aPRO_DOCTO_TIP   + 
				@aPRO_DOCTO_NRO   + 
				@aPRO_DENOMINA    + 
				@aPRO_CATEGO      + 
				@aPRO_PERMIT_FINAN   + 
				@aPRO_CUS_TIP  + 
				@aPRO_CUS_SUC  + 
				@aPRO_CUS_NRO  + 
				@aPRO_CBU_NRO   + 
				@aPRO_INGBRTS   + 
				@aPRO_CALLE + 
				@aPRO_NUMERO   + 
				@aPRO_DEPTO + 
				@aPRO_PISO  + 
				@aPRO_LOCALID  + 
				@aPRO_CPOSTAL  + 
				@aPRO_CODPROV  + 
				@aPRO_CODPAIS  + 
				@aPRO_EMAIL + 
				@aPRO_CALLE_ENTREGA   + 
				@aPRO_NUMERO_ENTREGA  + 
				@aPRO_DEPTO_ENTREGA   + 
				@aPRO_PISO_ENTREGA + 
				@aPRO_LOCALID_ENTREGA + 
				@aPRO_CPOSTAL_ENTREGA + 
				@aPRO_CODPROV_ENTREGA + 
				@aPRO_CODPAIS_ENTREGA + 
				@aPRO_TELEF_TIP + 
				@aPRO_TELEF_PRE + 
				@aPRO_TELEF_CAR + 
				@aPRO_TELEF_NRO + 
				@aPRO_TELEF_INT + 
				@aPRO_TELEF_ALTER_TIP + 
				@aPRO_TELEF_ALTER_PRE + 
				@aPRO_TELEF_ALTER_CAR + 
				@aPRO_TELEF_ALTER_NRO + 
				@aPRO_TELEF_ALTER_INT + 
				@aPRO_AUTORIZA_NOM1  + 
				@aPRO_AUTORIZA_TIP1  + 
				@aPRO_AUTORIZA_DOC1  + 
				@aPRO_AUTORIZA_NOM2  + 
				@aPRO_AUTORIZA_TIP2  + 
				@aPRO_AUTORIZA_DOC2  + 
				@aPRO_AUTORIZA_NOM3  + 
				@aPRO_AUTORIZA_TIP3  + 
				@aPRO_AUTORIZA_DOC3  + 
				@aPRO_DATOS + 
				@aPRO_MINUTA + 
				@aFILLER
				
/*================================================================================================================================*/
					
RETURN @Retorno
END
